import numpy as np
from PIL import Image, ImageDraw
import random
import os
import math

#this script generates model geometries in the shape of periodic "channel" protein censities in the AIS

path = r'/Users/jakobrentsch/FU Box/Papers/Stripes/JCB/Resubmission/Data/Scripts and raw data/Figure 1/h'

absolut_x_offset= 1000
absolut_y_offset= 1000

outline = [absolut_x_offset, absolut_y_offset, absolut_x_offset+2200, absolut_y_offset, absolut_x_offset+2200, absolut_y_offset +500, absolut_x_offset, absolut_y_offset +500]

im = Image.new('RGB', (4200, 2500))
draw = ImageDraw.Draw(im)

draw.polygon(outline)

size = 15   #diameter of circle
number = 100

r = size/2
xM = 20
yM =20

b = np.zeros((100,), dtype='f,f')
f = 0

x = 0

final_array = np.zeros(((number*11), 200))

for j in range (0, 2200, 200):

    random_array = np.zeros((number, 2))

    i=0
    while i < number:
        offy = random.randint(absolut_y_offset + math.ceil(size/2), absolut_y_offset + 500 - math.ceil(size/2))
        offx = random.randint(absolut_x_offset + 50, absolut_x_offset + 150)

        n = i

        while n > 0:
            if abs(offy - random_array[i-n,1]) > size or abs(offx - random_array[i-n, 0]) > size:
                n -= 1
        #print(i, n, random_array[i-n,1], offy, bool (abs(offy - random_array[i-n,1]) > 20) )

            else:
                offy = random.randint(absolut_y_offset + math.ceil(size/2), absolut_y_offset + 500 - math.ceil(size/2))
                offx = random.randint(absolut_x_offset + 50, absolut_x_offset + 150)
                n = i

        random_array[i, 1] = offy
        random_array[i, 0] = offx
        i += 1

    #print(random_array)




    for n in range (0,number):
        offx = random_array[n, 0] + j
        offy = random_array[n, 1]

        for p in np.arange(math.pi / 100, 2 * math.pi, 2 * math.pi / 100):
            Px = offx + r * math.cos(p)
            Py = offy + r * math.sin(p)

            final_array[x, 2*f-1] = Py/100
            final_array[x, 2*f] = Px/100
            draw.point((Px, Py))
            f += 1

        f = 0

        x += 1

im.show(im)

output_name = "channel-model_size-of-channel=" + str(size) + "_number-of-channels=" + str(number)

outline = np.array(outline)/100

if os.path.isfile(path + '/' + output_name + '.rgn'):
    os.remove(path + '/' + output_name + '.rgn')

outline_row = "0 3, 1 16711680, 2 0 0, 3 0 0, 4 0, 5 1, 6 4 "
for i in range(0, 8):
    outline_row = outline_row + str(outline[i]) + " "
outline_row = outline_row + ",7 1"

with open(path + '/' + output_name + '.rgn', 'a') as the_file:
    the_file.write(outline_row + '\n')


for j in range(0, number*11):
    new_row = "0 3, 1 16711680, 2 0 0, 3 0 0, 4 0, 5 1, 6 100 "

    for i in range(0, 200):
        new_row = new_row + str(final_array[j, i]) + " "
    new_row = new_row + ",7 1"

    with open(path + '/' + output_name + '.rgn', 'a') as the_file:
        the_file.write(new_row + '\n')

im.save(path + '/' + output_name + ".png")
